#!/bin/sh
if id -nGz "$USER" | grep -qzxF "dialout"
then
    echo User \`$USER\' belongs to group dialout
else
    echo User \`$USER\' does not belong to group dialout
    echo Please enter sudo pass to add user \`$USER\' to Group dialout to use serial and USB ports!
    sudo usermod -a -G dialout $USER
    echo Please Reboot your System!
fi
WBFOLDER="`dirname $0`"
cd ${WBFOLDER}
cd ..
JAR="`ls lib/falcom-project-workbench-[[:digit:]]*.jar`"
CLASSPATH="`ls lib/workbench-plugin-*.jar`"
echo "use following JARS : ${JAR}"
echo "use following Workbench Plugins : ${CLASSPATH}"
JAVADIR=./jre/bin/
JAVA=./jre/bin/java
chmod +x ${JAVA}

JAVA_LIB_PATH=./lib:./lib/linux_aarch64/
export JAVA_LIB_PATH
PATH=$JAVA_LIB_PATH:$JAVADIR:$PATH
export PATH
echo "start"
if [ -z "$CLASSPATH" ];then
  echo "${JAVA} -Djava.library.path=$JAVA_LIB_PATH -jar ${JAR}"
  ${JAVA} -Dfile.encoding=ISO-8859-1 -Djava.library.path=$JAVA_LIB_PATH -jar ${JAR}
else
  echo "${JAVA} -Djava.library.path=$JAVA_LIB_PATH -cp $CLASSPATH -jar ${JAR}"
  ${JAVA} -Dfile.encoding=ISO-8859-1 -Djava.library.path=$JAVA_LIB_PATH -cp $CLASSPATH -jar ${JAR}
fi
