#!/bin/sh
if id -nGz "$USER" | grep -qzxF "wheel"
then
    echo User \`$USER\' belongs to group wheel
else
    echo User \`$USER\' does not belong to group wheel
    echo Please enter sudo pass to add user \`$USER\' to Group wheel to use serial and USB ports!
    sudo usermod -a -G wheel $USER
    echo Please Reboot your System!
fi
WBFOLDER="`dirname $0`"
cd ${WBFOLDER}
cd ..
JAR="`ls lib/falcom-project-workbench-[[:digit:]]*.jar`"
CLASSPATH="`ls lib/workbench-plugin-*.jar`"
echo "use following JARS : ${JAR}"
JAVADIR=./jre/bin/
JAVA=./jre/bin/java
chmod +x ${JAVA}
export JAVA_PATH=./jre
export JAVA_HOME=./jre
JAVA_LIB_PATH=./lib:./lib/macosx_x86_64/
export JAVA_LIB_PATH
PATH=$JAVA_LIB_PATH:$JAVADIR:$PATH
export PATH

echo "start"
if [ -z "$CLASSPATH" ];then
  echo "${JAVA} -Djava.library.path=$JAVA_LIB_PATH -XstartOnFirstThread -jar ${JAR}"
  ${JAVA} -Dfile.encoding=ISO-8859-1 -Djava.library.path=$JAVA_LIB_PATH -XstartOnFirstThread -jar ${JAR}
else
  echo "${JAVA} -Djava.library.path=$JAVA_LIB_PATH -XstartOnFirstThread -cp $CLASSPATH -jar ${JAR}"
  ${JAVA} -Dfile.encoding=ISO-8859-1 -Djava.library.path=$JAVA_LIB_PATH -XstartOnFirstThread -cp $CLASSPATH -jar ${JAR}
fi